<?php $__env->startSection('title', 'Statistics'); ?>

<?php $__env->startSection('content'); ?>
  <!-- Game Stats -->
  <div class="stats-grid">
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-gamepad"></i> Total Rounds</div>
      <div class="stat-value"><?php echo e($totalRounds); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-dice"></i> Average Multiplier</div>
      <div class="stat-value"><?php echo e(number_format($avgMultiplier, 2, ',', '.')); ?>x</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-trophy"></i> Highest Multiplier</div>
      <div class="stat-value"><?php echo e(number_format($highestMultiplier, 2, ',', '.')); ?>x</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-users"></i> Active Players</div>
      <div class="stat-value"><?php echo e($activeUsers); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-coins"></i> Total Bets</div>
      <div class="stat-value"><?php echo e($totalBets); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-chart-line"></i> Total Won</div>
      <div class="stat-value"><?php echo e($totalWins); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-times-circle"></i> Total Lost</div>
      <div class="stat-value"><?php echo e($totalLosses); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-percentage"></i> Win Rate</div>
      <div class="stat-value">
        <?php if($totalBets > 0): ?>
          <?php echo e(number_format(($totalWins / $totalBets) * 100, 1, ',', '.')); ?>%
        <?php else: ?>
          0%
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Tabbed Table Card -->
  <div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
      <button class="tab-btn active" data-tab="recent-rounds" onclick="switchTab('recent-rounds', this)">
        <i class="fas fa-history"></i> Recent Rounds
      </button>
      <button class="tab-btn" data-tab="top-winners" onclick="switchTab('top-winners', this)">
        <i class="fas fa-medal"></i> Top Winners
      </button>
    </div>

    <!-- Recent Rounds Tab -->
    <div id="recent-rounds" class="tab-content active">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>Multiplier</th>
              <th>Winner</th>
              <th>Won Amount</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $recentRounds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $round): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($round->id); ?></td>
                <td>
                  <span class="status-badge status-success"><?php echo e(number_format($round->multiplier, 2, ',', '.')); ?>x</span>
                </td>
                <td><?php echo e($round->winner_name ?? '-'); ?></td>
                <td>
                  <?php if($round->won_amount): ?>
                    R$ <?php echo e(number_format($round->won_amount, 2, ',', '.')); ?>

                  <?php else: ?>
                    -
                  <?php endif; ?>
                </td>
                <td><?php echo e($round->created_at->format('M d, Y H:i')); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="5">No rounds found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
    </div>

    <!-- Top Winners Tab -->
    <div id="top-winners" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>Rank</th>
              <th>User</th>
              <th>Total Won</th>
              <th>Total Bets</th>
              <th>Win Rate</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $topWinners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $winner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>
                  <?php if($index == 0): ?>
                    <i class="fas fa-trophy" style="color: #FFD700; font-size: 20px;"></i>
                  <?php elseif($index == 1): ?>
                    <i class="fas fa-trophy" style="color: #C0C0C0; font-size: 18px;"></i>
                  <?php elseif($index == 2): ?>
                    <i class="fas fa-trophy" style="color: #CD7F32; font-size: 16px;"></i>
                  <?php else: ?>
                    #<?php echo e($index + 1); ?>

                  <?php endif; ?>
                </td>
                <td><?php echo e($winner->name ?? 'Unknown'); ?></td>
                <td class="status-badge status-success">R$ <?php echo e(number_format($winner->total_wins, 2, ',', '.')); ?></td>
                <td>-</td>
                <td>-</td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="5">No winners found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
    </div>
  </div>

  <script>
    function switchTab(tabId, button) {
      document.querySelectorAll('.tab-content').forEach(function(content) {
        content.classList.remove('active');
      });

      document.querySelectorAll('.tab-btn').forEach(function(btn) {
        btn.classList.remove('active');
      });

      document.getElementById(tabId).classList.add('active');
      button.classList.add('active');
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/admin/statistics.blade.php ENDPATH**/ ?>