<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
  <div class="card">
    <div class="card-title"><i class="fas fa-users"></i> All Users</div>
    <div class="table-container">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Balance</th>
            <th>Role</th>
            <th>Banned</th>
            <th>Status</th>
            <th>Joined</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
              <td>#<?php echo e($user->id); ?></td>
              <td><?php echo e($user->name); ?></td>
              <td><?php echo e($user->email); ?></td>
              <td><?php echo e($user->phone ?? '-'); ?></td>
              <td>R$ <?php echo e(number_format($user->balance, 2, ',', '.')); ?></td>
              <td>
                <?php if($user->role_id == 1): ?>
                  <span class="status-badge status-success"><i class="fas fa-user-shield"></i> Admin</span>
                <?php else: ?>
                  <span class="status-badge status-pending"><i class="fas fa-user"></i> User</span>
                <?php endif; ?>
              </td>
              <td>
                <?php if($user->banned): ?>
                  <span class="status-badge status-error"><i class="fas fa-ban"></i> Yes</span>
                <?php else: ?>
                  <span class="status-badge status-success"><i class="fas fa-check"></i> No</span>
                <?php endif; ?>
              </td>
              <td>
                <?php if($user->status): ?>
                  <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Active</span>
                <?php else: ?>
                  <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Inactive</span>
                <?php endif; ?>
              </td>
              <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
              <td>
                <a href="<?php echo e(route('admin.users.show', $user->id)); ?>" class="btn btn-sm btn-primary">
                  <i class="fas fa-eye"></i> View
                </a>
                <form action="<?php echo e(route('admin.users.ban', $user->id)); ?>" method="POST" style="display: inline;">
                  <?php echo csrf_field(); ?>
                  <?php echo method_field('PATCH'); ?>
                  <button type="submit" class="btn btn-sm <?php echo e($user->banned ? 'btn-success' : 'btn-danger'); ?>">
                    <i class="fas fa-<?php echo e($user->banned ? 'unlock' : 'ban'); ?>"></i> <?php echo e($user->banned ? 'Unban' : 'Ban'); ?>

                  </button>
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
              <td colspan="10">No users found</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
    
    <?php if($users->hasPages()): ?>
      <div style="margin-top: 20px; text-align: center;">
        <?php echo e($users->links()); ?>

      </div>
    <?php endif; ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/admin/users.blade.php ENDPATH**/ ?>