<div class="modal" id="paymentSuccessModal">
  <div class="modal-overlay"></div>
  <div class="modal-container modal-container-small">
    <div class="modal-header">
      <h2>Payment Success!</h2>
      <button class="modal-close" onclick="closeModal('paymentSuccessModal')">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </div>
    <div class="modal-body">
      <div class="success-icon-container">
        <svg class="success-icon" width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <circle cx="12" cy="12" r="10" stroke="#12DF38"/>
          <polyline points="9 12 11 14 15 10" stroke="#12DF38" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
      </div>
      <h3 id="paymentSuccessMessage">Payment processed successfully!</h3>
      <p class="success-description">Your account has been credited.</p>
      <div class="balance-update-info">
        <span class="label">New Balance:</span>
        <span class="value" id="paymentSuccessBalance">-</span>
      </div>
      <div class="modal-footer" style="margin-top: 24px; justify-content: center;">
        <button type="button" class="btn-primary" onclick="closeModal('paymentSuccessModal')">Continue</button>
      </div>
    </div>
  </div>
</div>

<script>
  function showPaymentSuccessModal(message, balance, formattedBalance) {
    const modal = document.getElementById('paymentSuccessModal');
    const messageEl = document.getElementById('paymentSuccessMessage');
    const balanceEl = document.getElementById('paymentSuccessBalance');
    
    if (messageEl) messageEl.textContent = message;
    if (balanceEl && formattedBalance) balanceEl.textContent = 'R$ ' + formattedBalance;
    
    if (modal && window.openModal) {
      window.openModal('paymentSuccessModal');
    } else if (modal) {
      modal.style.display = 'flex';
      document.body.style.overflow = 'hidden';
      setTimeout(() => {
        modal.classList.add('active');
      }, 10);
    }
  }
  
  function showPaymentInfoModal(message) {
    alert(message); // Simple alert for pending payments
  }
  
  window.showPaymentSuccessModal = showPaymentSuccessModal;
  window.showPaymentInfoModal = showPaymentInfoModal;
  
  // Close modal handler
  document.addEventListener('DOMContentLoaded', function() {
    const closeBtn = document.querySelector('#paymentSuccessModal .modal-close');
    const overlay = document.querySelector('#paymentSuccessModal .modal-overlay');
    
    if (closeBtn) {
      closeBtn.addEventListener('click', function() {
        if (window.closeModal) {
          window.closeModal('paymentSuccessModal');
        }
      });
    }
    
    if (overlay) {
      overlay.addEventListener('click', function() {
        if (window.closeModal) {
          window.closeModal('paymentSuccessModal');
        }
      });
    }
  });
</script>
<?php /**PATH C:\Users\aduam\Documents\GitHub\aviator_clone_complete\upgrade\aviator_crash\resources\views/modals/payment-success.blade.php ENDPATH**/ ?>