<?php $__env->startSection('title', 'Finances'); ?>

<?php $__env->startSection('content'); ?>
  <!-- Finance Stats -->
  <div class="stats-grid">
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-download"></i> Total Deposits</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['total_deposits'], 2, ',', '.')); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-upload"></i> Total Withdrawals</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['total_withdrawals'], 2, ',', '.')); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-clock"></i> Pending Deposits</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['pending_deposits'], 2, ',', '.')); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-hourglass-half"></i> Pending Withdrawals</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['pending_withdrawals'], 2, ',', '.')); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-chart-line"></i> Net Profit</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['net_profit'], 2, ',', '.')); ?></div>
    </div>
  </div>

  <!-- Tabbed Table Card -->
  <div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
      <button class="tab-btn active" data-tab="deposits" onclick="switchTab('deposits', this)">
        <i class="fas fa-money-bill-wave"></i> Deposits
      </button>
      <button class="tab-btn" data-tab="withdrawals" onclick="switchTab('withdrawals', this)">
        <i class="fas fa-money-check-alt"></i> Withdrawals
      </button>
    </div>

    <!-- Deposits Tab -->
    <div id="deposits" class="tab-content active">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
              <th>Date</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($deposit->id); ?></td>
                <td>
                  <div><?php echo e($deposit->user_name); ?></div>
                  <small style="color: #888;"><?php echo e($deposit->user_email); ?></small>
                </td>
                <td>R$ <?php echo e(number_format($deposit->amount, 2, ',', '.')); ?></td>
                <td>
                  <?php if($deposit->status == 1): ?>
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  <?php elseif($deposit->status == 0): ?>
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  <?php else: ?>
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($deposit->created_at->format('M d, Y H:i')); ?></td>
                <td>
                  <?php if($deposit->status == 0): ?>
                    <form action="<?php echo e(route('admin.finances.deposit.approve', $deposit->id)); ?>" method="POST" style="display: inline;">
                      <?php echo csrf_field(); ?>
                      <?php echo method_field('PATCH'); ?>
                      <button type="submit" class="btn btn-sm btn-success"><i class="fas fa-check"></i></button>
                    </form>
                    <form action="<?php echo e(route('admin.finances.deposit.reject', $deposit->id)); ?>" method="POST" style="display: inline;">
                      <?php echo csrf_field(); ?>
                      <?php echo method_field('PATCH'); ?>
                      <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></button>
                    </form>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="6">No deposits found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
      <?php if($deposits->hasPages()): ?>
        <div style="margin-top: 20px; text-align: center;">
          <?php echo e($deposits->links()); ?>

        </div>
      <?php endif; ?>
    </div>

    <!-- Withdrawals Tab -->
    <div id="withdrawals" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
              <th>Date</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($withdrawal->id); ?></td>
                <td>
                  <div><?php echo e($withdrawal->user_name); ?></div>
                  <small style="color: #888;"><?php echo e($withdrawal->user_email); ?></small>
                </td>
                <td>R$ <?php echo e(number_format($withdrawal->amount, 2, ',', '.')); ?></td>
                <td>
                  <?php if($withdrawal->status == 1): ?>
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  <?php elseif($withdrawal->status == 0): ?>
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  <?php else: ?>
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($withdrawal->created_at->format('M d, Y H:i')); ?></td>
                <td>
                  <?php if($withdrawal->status == 0): ?>
                    <form action="<?php echo e(route('admin.finances.withdrawal.approve', $withdrawal->id)); ?>" method="POST" style="display: inline;">
                      <?php echo csrf_field(); ?>
                      <?php echo method_field('PATCH'); ?>
                      <button type="submit" class="btn btn-sm btn-success"><i class="fas fa-check"></i></button>
                    </form>
                    <form action="<?php echo e(route('admin.finances.withdrawal.reject', $withdrawal->id)); ?>" method="POST" style="display: inline;">
                      <?php echo csrf_field(); ?>
                      <?php echo method_field('PATCH'); ?>
                      <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></button>
                    </form>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="6">No withdrawals found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
      <?php if($withdrawals->hasPages()): ?>
        <div style="margin-top: 20px; text-align: center;">
          <?php echo e($withdrawals->links()); ?>

        </div>
      <?php endif; ?>
    </div>
  </div>

  <script>
    function switchTab(tabId, button) {
      // Hide all tab contents
      document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.remove('active');
      });

      // Remove active class from all buttons
      document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.classList.remove('active');
      });

      // Show selected tab content
      document.getElementById(tabId).classList.add('active');

      // Add active class to clicked button
      button.classList.add('active');
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/admin/finances.blade.php ENDPATH**/ ?>