<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Aviator Game</title>
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@700&family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('css/styles.css')); ?>">
  
</head>
<body>
  <!-- Loader -->
  <div class="loader-container" id="loader">
    <div class="loader">
      <div class="powered">POWERED BY</div>
      <div class="logo">SPRIBE</div>
      <div class="dots">
        <div class="dot"></div>
        <div class="dot"></div>
        <div class="dot"></div>
      </div>
    </div>
  </div>

  <!-- Main Game Interface -->
  <div class="game-container" id="gameContainer">
    <!-- Header -->
    <?php echo $__env->make('components.header.game-header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="main-content" id="mainContent">
      <!-- Mobile Sidebar Toggle -->
      <div class="sidebar-toggle-mobile" id="sidebarMenuIcon" style="display: none;">
        <span></span>
        <span></span>
        <span></span>
      </div>
      
      <!-- Sidebar -->
      <?php echo $__env->make('components.sidebar.left-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

      <div class="main-column">
        <!-- Multipliers -->
        <?php echo $__env->make('components.game-area.multipliers', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
          
        <!-- Game Area -->
        <?php echo $__env->make('components.game-area.game-canvas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Bottom Panel -->
        <div class="panels-wrapper">
          <!-- First Bet Panel -->
          <?php echo $__env->make('components.betting.betting-panel', ['panelIndex' => 0], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

          <!-- Second Bet Panel -->
          <?php echo $__env->make('components.betting.betting-panel', ['panelIndex' => 1], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
      </div>

      <!-- Chat Sidebar (visible on large screens) -->
      <?php echo $__env->make('components.chat.chat-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
  </div>

  <audio id="bgMusic" loop src="<?php echo e(asset('assets/bg_music.mp3')); ?>"></audio>
  <audio id="spriteAudio" src="<?php echo e(asset('assets/sprite_audio.mp3')); ?>"></audio>
  <script src="<?php echo e(asset('js/script.js')); ?>"></script>
  <script src="<?php echo e(asset('js/buttonscript.js')); ?>"></script>
  <div id="notification-container"></div>

  <?php if(auth()->guard()->check()): ?>
  <!-- Modals -->
  <?php echo $__env->make('modals.topup', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.profile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.withdraw', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.history', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.logout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.payment-success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.how-to-play', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.game-rules', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php endif; ?>

  <script>
    // User menu dropdown and modal functionality
    document.addEventListener('DOMContentLoaded', function() {
      initUserMenu();
      initModals();
      initSettings();
      initChat();
    });

    // Initialize user menu dropdown
    function initUserMenu() {
      const menuIcon = document.getElementById('userMenuIcon');
      const dropdown = document.getElementById('userMenuDropdown');
      
      if (menuIcon && dropdown) {
        console.log('Initializing user menu dropdown...');
        console.log('Menu icon found:', !!menuIcon);
        console.log('Dropdown found:', !!dropdown);
        
        // Toggle dropdown on click
        menuIcon.addEventListener('click', function(e) {
          e.stopPropagation();
          e.preventDefault();
          dropdown.classList.toggle('active');
          const isActive = dropdown.classList.contains('active');
          menuIcon.setAttribute('aria-expanded', isActive.toString());
          console.log('Dropdown toggled:', isActive);
        });

        // Prevent clicks inside dropdown from bubbling up
        dropdown.addEventListener('click', function(e) {
          e.stopPropagation();
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
          if (!menuIcon.contains(e.target) && !dropdown.contains(e.target)) {
            dropdown.classList.remove('active');
            menuIcon.setAttribute('aria-expanded', 'false');
          }
        });
        
        console.log('User menu dropdown initialized successfully');
      } else {
        console.error('User menu elements not found', {
          menuIcon: !!menuIcon,
          dropdown: !!dropdown
        });
      }
    }
    
    // Initialize modals
    function initModals() {
      console.log('Initializing modals...');
      
      // Close dropdown helper function (accessible globally)
      window.closeUserDropdown = function() {
        const dropdown = document.getElementById('userMenuDropdown');
        const menuIcon = document.getElementById('userMenuIcon');
        if (dropdown) {
          dropdown.classList.remove('active');
          if (menuIcon) {
            menuIcon.setAttribute('aria-expanded', 'false');
          }
        }
      };
      
      // Global modal functions
      window.openModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) {
          modal.classList.add('active');
          document.body.style.overflow = 'hidden';
          console.log('Opening modal:', modalId);
          // Close dropdown when opening modal
          window.closeUserDropdown();
        }
      };
      
      window.closeModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) {
          modal.classList.remove('active');
          document.body.style.overflow = '';
          console.log('Closing modal:', modalId);
        }
      };
      
      // Close modals when clicking overlay
      document.querySelectorAll('.modal-overlay').forEach(overlay => {
        overlay.addEventListener('click', function(e) {
          if (e.target === overlay) {
            const modal = overlay.closest('.modal');
            if (modal) {
              closeModal(modal.id);
            }
          }
        });
      });
      
      // Close modals with Escape key
      document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
          document.querySelectorAll('.modal.active').forEach(modal => {
            closeModal(modal.id);
          });
        }
      });
      
      console.log('Modals initialized successfully');
    }
    
    // Initialize settings toggles
    function initSettings() {
      console.log('Initializing settings...');
      
      const soundToggle = document.getElementById('soundToggle');
      const musicToggle = document.getElementById('musicToggle');
      const animationToggle = document.getElementById('animationToggle');
      
      if (soundToggle) {
        soundToggle.addEventListener('change', function() {
          localStorage.setItem('soundEnabled', this.checked);
          const spriteAudio = document.getElementById('spriteAudio');
          if (spriteAudio) {
            if (this.checked) {
              spriteAudio.volume = 1;
            } else {
              spriteAudio.volume = 0;
            }
          }
        });
        const soundEnabled = localStorage.getItem('soundEnabled');
        if (soundEnabled !== null) {
          soundToggle.checked = soundEnabled === 'true';
        }
      }
      
      if (musicToggle) {
        musicToggle.addEventListener('change', function() {
          localStorage.setItem('musicEnabled', this.checked);
          const bgMusic = document.getElementById('bgMusic');
          if (bgMusic) {
            if (this.checked) {
              bgMusic.volume = 0.3;
              bgMusic.play().catch(e => console.log('Music play prevented'));
            } else {
              bgMusic.pause();
              bgMusic.volume = 0;
            }
          }
        });
        const musicEnabled = localStorage.getItem('musicEnabled');
        if (musicEnabled !== null) {
          musicToggle.checked = musicEnabled === 'true';
        }
      }
      
      if (animationToggle) {
        animationToggle.addEventListener('change', function() {
          localStorage.setItem('animationEnabled', this.checked);
          document.body.classList.toggle('animations-disabled', !this.checked);
        });
        const animationEnabled = localStorage.getItem('animationEnabled');
        if (animationEnabled !== null) {
          animationToggle.checked = animationEnabled === 'true';
        }
      }
      
      console.log('Settings initialized successfully');
    }
    
    // Chat Initialization
    function initChat() {
      const chatInput = document.getElementById('chatInput');
      const sendChatBtn = document.getElementById('sendChatBtn');
      const chatMessages = document.getElementById('chat-messages');
      
      if (!chatInput || !sendChatBtn || !chatMessages) {
        console.log('Chat elements not found');
        return;
      }
      
      console.log('Initializing chat...');

      // Random message templates
      const randomMessages = {
        wins: [
          "Finally got a win! 2.5x 💰",
          "Cash out at 1.8x, better than nothing",
          "Just won big! 5.2x 🔥🔥🔥",
          "Small win 1.5x, building up slowly",
          "Cashed out at 3.1x! Yes! 🎉",
          "Need just one big win to recover",
          "2.1x, slowly climbing back",
          "Won 1.9x, patience is key",
          "4.5x baby! 🚀",
          "3.8x, good run today",
          "Cashed at 2.2x, safe play",
          "1.6x but consistent wins",
          "Just recovered my losses! 6.2x 💪",
          "5.8x! On fire today! 🌟",
          "2.4x, steady progress",
          "Huge win! 10.5x 🎰💎",
          "3.5x, doing okay",
          "Cashed at 4.1x, happy with that",
          "1.3x, small but consistent",
          "Won 7.2x! Best today! 🏆"
        ],
        losses: [
          "Flew away too early 😭",
          "Should have cashed out at 1.5x",
          "Greedy again 😢",
          "Need to control myself",
          "Lost again, trying to recover",
          "This game is rigged sometimes",
          "1.2x and it flew away",
          "Almost made it but no",
          "Lost big today 😭😭",
          "Just want to break even",
          "Always miss the good ones",
          "My luck is terrible today",
          "Another loss, keep trying",
          "1.1x and gone, typical",
          "Why do I keep playing?",
          "Need to stop being greedy",
          "Lost everything back",
          "Starting from zero again",
          "This is frustrating",
          "Can't catch a break",
          "1.3x was my limit",
          "Learning the hard way",
          "Today is not my day",
          "Just one good round please",
          "The pain is real 😭",
          "Keep calm and bet responsibly",
          "Need better discipline"
        ],
        gameplay: [
          "Any predictions for next round?",
          "What's the strategy today?",
          "Think it will go high?",
          "Watching the patterns",
          "Patience is key in this game",
          "Don't chase losses",
          "Set limits and stick to them",
          "Slow and steady wins",
          "Looking for 2x+ multipliers",
          "This game is about timing",
          "Need to focus",
          "Just testing the waters",
          "Small bets for now",
          "Building my bankroll slowly",
          "Anyone cashing out big today?",
          "Let's see what happens",
          "Taking a break after this",
          "New round, new hope",
          "Following the trend",
          "Playing it safe today",
          "What's everyone's strategy?",
          "Need to be more disciplined",
          "Learning as I go",
          "Taking it one round at a time",
          "Small wins are still wins",
          "Don't get greedy",
          "Stay calm everyone",
          "Just here for fun",
          "Trying my luck",
          "Hope for the best"
        ],
        reactions: [
          "Wow! 🎉",
          "Amazing! 🔥",
          "Nice! 💪",
          "Unbelievable! 🚀",
          "Let's go! 🙌",
          "Yes! 🎊",
          "Incredible! 💎",
          "Too good! ⭐",
          "Perfect! ✨",
          "Fantastic! 🌟",
          "Awesome! 🎯",
          "Brilliant! 💫",
          "Great! 👏",
          "Beautiful! 🌈",
          "Stunning! 🏆",
          "Wow wow wow! 🎉🎉",
          "Can't believe it! 😱",
          "So good! 😍",
          "Amazing run! 💰💰",
          "Best ever! 🏅"
        ],
        greetings: [
          "Hey everyone! 👋",
          "Good luck all! 🍀",
          "Let's win together! 💪",
          "New here, wish me luck",
          "Good vibes only! ✨",
          "Hello chat! 👋",
          "Hope today is better",
          "Ready to play! 🎮",
          "Let's make it happen! 🚀",
          "Good evening/morning everyone!",
          "Best of luck! 🍀🍀",
          "Stay positive! 🌟",
          "We can do this! 💪",
          "Keep going everyone!",
          "Stay focused! 🎯"
        ]
      };

      const usernames = [
        "Player1", "Winner23", "Lucky7", "GameMaster", "AviatorPro",
        "CashOut", "BetBig", "SkyHigh", "FlyAway", "Multiplier",
        "BetKing", "WinStreak", "ProGamer", "LuckyDraw", "AcePlayer",
        "StarWinner", "GoldenEgg", "RocketMan", "CloudHigh", "BigWin",
        "SwiftCash", "QuickWin", "ProBet", "MasterMind", "LuckyStar",
        "WinnerZone", "BetChamp", "SkyRise", "AviatorX", "MultiplierPro"
      ];

      // Helper functions
      function getRandomItem(arr) {
        return arr[Math.floor(Math.random() * arr.length)];
      }

      function getRandomNumber(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
      }

      function maskUsername(username) {
        if (username.length <= 2) return username;
        const firstChar = username.charAt(0);
        const lastChar = username.charAt(username.length - 1);
        const masked = '*'.repeat(username.length - 2);
        return firstChar + masked + lastChar;
      }

      function generateRandomUsername() {
        const baseName = getRandomItem(usernames);
        const randomNum = getRandomNumber(100, 999);
        return baseName + randomNum;
      }

      // Create chat message element
      function createChatMessage(username, text, likeCount = 0) {
        const messageDiv = document.createElement('div');
        messageDiv.className = 'chat-message';
        
        const randomSeed = Math.random().toString(36).substring(7);
        const maskedName = maskUsername(username);
        
        messageDiv.innerHTML = 
          '<div class="avatar" style="background-image: url(\'https://i.pravatar.cc/20?u=' + randomSeed + '\')"></div>' +
          '<div class="chat-content">' +
            '<div class="chat-username">' + maskedName + '</div>' +
            (text ? '<div class="chat-text">' + escapeHtml(text) + '</div>' : '') +
          '</div>' +
          '<div class="chat-reactions">' +
            '<span class="chat-like-count">' + likeCount + '</span>' +
            '<button class="chat-like-btn">👍</button>' +
          '</div>';
        
        return messageDiv;
      }

      // Escape HTML to prevent XSS
      function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
      }

      // Add message to chat
      function addMessage(username, text, likeCount = 0) {
        const message = createChatMessage(username, text, likeCount);
        chatMessages.appendChild(message);
        
        // Scroll to bottom
        chatMessages.scrollTop = chatMessages.scrollHeight;
        
        // Remove old messages if too many (keep last 50)
        while (chatMessages.children.length > 50) {
          chatMessages.removeChild(chatMessages.firstChild);
        }
      }

      // Send user message
      function sendUserMessage() {
        const text = chatInput.value.trim();
        if (!text) return;
        
        // Use "You" as the username for now
        const userName = "You";
        addMessage(userName, text, 0);
        
        // Clear input
        chatInput.value = '';
        
        // Focus back on input for rapid messaging
        chatInput.focus();
      }

      // Generate random message
      function generateRandomMessage() {
        // Choose random category
        const categories = ['wins', 'losses', 'gameplay', 'reactions', 'greetings'];
        const category = getRandomItem(categories);
        
        // Get random message from category
        const messages = randomMessages[category];
        const message = getRandomItem(messages);
        
        // Generate random username
        const username = generateRandomUsername();
        
        // Generate random like count
        const likeCount = getRandomNumber(0, 15);
        
        addMessage(username, message, likeCount);
      }

      // Add initial messages if chat is empty
      function addInitialMessages() {
        // Clear existing messages and add fresh ones
        chatMessages.innerHTML = '';
        
        // Add 15-20 initial random messages
        const initialCount = getRandomNumber(15, 20);
        console.log('Adding ' + initialCount + ' initial messages');
        
        for (let i = 0; i < initialCount; i++) {
          generateRandomMessage();
        }
      }

      // Auto-generate random messages periodically
      function startAutoMessages() {
        // Generate new message every 1-2 seconds for CRAZY chat activity
        const interval = getRandomNumber(1000, 2000);
        console.log('Auto messages starting every ' + interval + 'ms');
        
        setInterval(function() {
          // 95% chance to generate message (very active chat)
          if (Math.random() < 0.95) {
            generateRandomMessage();
          }
        }, interval);
        
        // Also add random bursts of messages
        setInterval(function() {
          if (Math.random() < 0.3) {
            // Generate 2-4 messages at once during burst
            const burstCount = getRandomNumber(2, 4);
            for (let i = 0; i < burstCount; i++) {
              setTimeout(function() {
                generateRandomMessage();
              }, i * 200);
            }
          }
        }, 5000);
      }

      // Event Listeners
      sendChatBtn.addEventListener('click', sendUserMessage);
      
      chatInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
          sendUserMessage();
        }
      });

      // Like button functionality
      chatMessages.addEventListener('click', function(e) {
        if (e.target.classList.contains('chat-like-btn')) {
          const likeCountEl = e.target.parentElement.querySelector('.chat-like-count');
          const currentCount = parseInt(likeCountEl.textContent);
          likeCountEl.textContent = currentCount + 1;
          
          // Add animation
          e.target.style.transform = 'scale(1.2)';
          setTimeout(function() {
            e.target.style.transform = 'scale(1)';
          }, 200);
        }
      });

      // Initialize chat
      console.log('Adding initial messages...');
      addInitialMessages();
      
      // Start auto messages after 1 second
      console.log('Starting auto messages...');
      setTimeout(function() {
        startAutoMessages();
      }, 1000);
      
      console.log('Chat initialized successfully!');
    }
  </script>
</body>
</html>
<?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/game.blade.php ENDPATH**/ ?>