<div class="modal" id="topupModal">
  <div class="modal-overlay"></div>
  <div class="modal-container">
    <div class="modal-header">
      <h2>Topup Account</h2>
      <button class="modal-close" onclick="closeModal('topupModal')">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </div>
    <div class="modal-body">
      <form id="topupForm" onsubmit="handleTopup(event)">
        <?php echo csrf_field(); ?>
        <div class="form-group">
          <label for="topupAmount">Amount (R$)</label>
          <input type="number" id="topupAmount" name="amount" min="10" step="0.01" placeholder="Enter amount" required>
          <small class="form-hint">Minimum: R$ 10.00</small>
        </div>
        
        <div class="form-group">
          <label for="topupMethod">Payment Method</label>
          <select id="topupMethod" name="method" required>
            <option value="">Select payment method</option>
            <option value="pix">PIX</option>
            <option value="card">Credit Card</option>
            <option value="bank_transfer">Bank Transfer</option>
          </select>
        </div>
        
        <div class="form-group" id="pixFields" style="display: none;">
          <label for="pixKey">PIX Key</label>
          <input type="text" id="pixKey" name="pix_key" placeholder="Enter your PIX key">
          <label for="pixType" style="margin-top: 10px;">PIX Key Type</label>
          <select id="pixType" name="pix_type">
            <option value="document">CPF/CNPJ</option>
            <option value="email">Email</option>
            <option value="phone">Phone</option>
            <option value="random">Random Key</option>
          </select>
        </div>
        
        <div class="form-group" id="cardFields" style="display: none;">
          <label for="cardNumber">Card Number</label>
          <input type="text" id="cardNumber" name="card_number" placeholder="1234 5678 9012 3456" maxlength="19">
          <label for="cardHolder" style="margin-top: 10px;">Card Holder Name</label>
          <input type="text" id="cardHolder" name="card_holder" placeholder="JOHN DOE">
          <div style="display: flex; gap: 10px; margin-top: 10px;">
            <div style="flex: 1;">
              <label for="cardExpiry">Expiry Date</label>
              <input type="text" id="cardExpiry" name="card_expiry" placeholder="MM/YY" maxlength="5">
            </div>
            <div style="flex: 1;">
              <label for="cardCvv">CVV</label>
              <input type="text" id="cardCvv" name="card_cvv" placeholder="123" maxlength="4">
            </div>
          </div>
        </div>
        
        <div class="form-group" id="bankFields" style="display: none;">
          <label for="bankName">Bank Name</label>
          <input type="text" id="bankName" name="bank_name" placeholder="Enter bank name">
          <label for="accountNumber" style="margin-top: 10px;">Account Number</label>
          <input type="text" id="accountNumber" name="account_number" placeholder="Enter account number">
          <label for="accountHolder" style="margin-top: 10px;">Account Holder Name</label>
          <input type="text" id="accountHolder" name="account_holder" placeholder="Enter account holder name">
          <label for="routingNumber" style="margin-top: 10px;">Routing Number (Optional)</label>
          <input type="text" id="routingNumber" name="routing_number" placeholder="Enter routing number">
        </div>
        
        <div class="quick-amounts">
          <span class="quick-amount-label">Quick Amount:</span>
          <button type="button" class="quick-btn" onclick="setAmount(50)">R$ 50</button>
          <button type="button" class="quick-btn" onclick="setAmount(100)">R$ 100</button>
          <button type="button" class="quick-btn" onclick="setAmount(200)">R$ 200</button>
          <button type="button" class="quick-btn" onclick="setAmount(500)">R$ 500</button>
        </div>
        
        <div class="modal-footer">
          <button type="button" class="btn-secondary" onclick="closeModal('topupModal')">Cancel</button>
          <button type="submit" class="btn-primary">Proceed to Payment</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  function setAmount(amount) {
    document.getElementById('topupAmount').value = amount;
  }
  
  // Show/hide fields based on payment method
  document.getElementById('topupMethod')?.addEventListener('change', function(e) {
    const method = e.target.value;
    const pixFields = document.getElementById('pixFields');
    const cardFields = document.getElementById('cardFields');
    const bankFields = document.getElementById('bankFields');
    
    // Hide all fields first
    pixFields.style.display = 'none';
    cardFields.style.display = 'none';
    bankFields.style.display = 'none';
    
    // Remove required from all fields
    document.querySelectorAll('#pixFields input, #pixFields select').forEach(el => el.required = false);
    document.querySelectorAll('#cardFields input').forEach(el => el.required = false);
    document.querySelectorAll('#bankFields input').forEach(el => el.required = false);
    
    // Show and require relevant fields based on method
    if (method === 'pix') {
      pixFields.style.display = 'block';
      document.getElementById('pixKey').required = true;
    } else if (method === 'card') {
      cardFields.style.display = 'block';
      document.getElementById('cardNumber').required = true;
      document.getElementById('cardHolder').required = true;
      document.getElementById('cardExpiry').required = true;
      document.getElementById('cardCvv').required = true;
    } else if (method === 'bank_transfer') {
      bankFields.style.display = 'block';
      document.getElementById('bankName').required = true;
      document.getElementById('accountNumber').required = true;
      document.getElementById('accountHolder').required = true;
    }
  });
  
  // Format card number input (add spaces)
  document.getElementById('cardNumber')?.addEventListener('input', function(e) {
    let value = e.target.value.replace(/\s/g, '');
    let formattedValue = value.match(/.{1,4}/g)?.join(' ') || value;
    if (formattedValue.length <= 19) {
      e.target.value = formattedValue;
    }
  });
  
  // Format expiry date input (MM/YY)
  document.getElementById('cardExpiry')?.addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    if (value.length >= 2) {
      value = value.substring(0, 2) + '/' + value.substring(2, 4);
    }
    e.target.value = value;
  });
  
  // Only allow numbers for CVV
  document.getElementById('cardCvv')?.addEventListener('input', function(e) {
    e.target.value = e.target.value.replace(/\D/g, '');
  });
  
  function handleTopup(e) {
    e.preventDefault();
    const formData = new FormData(e.target);
    const data = {};
    
    // Only include relevant fields based on selected payment method
    const method = formData.get('method');
    data.amount = formData.get('amount');
    data.method = method;
    
    // Validate and include fields relevant to the selected payment method
    if (method === 'pix') {
      const pixKey = formData.get('pix_key');
      if (pixKey && pixKey.trim()) {
        data.pix_key = pixKey.trim();
      } else {
        alert('Please enter your PIX key');
        return;
      }
      const pixType = formData.get('pix_type');
      if (pixType) {
        data.pix_type = pixType;
      }
    } else if (method === 'card') {
      const cardNumber = formData.get('card_number');
      if (cardNumber && cardNumber.trim().replace(/\s/g, '').length >= 13) {
        data.card_number = cardNumber.trim();
      } else {
        alert('Please enter a valid card number');
        return;
      }
      const cardHolder = formData.get('card_holder');
      if (cardHolder && cardHolder.trim().length >= 3) {
        data.card_holder = cardHolder.trim();
      } else {
        alert('Please enter card holder name');
        return;
      }
      const cardExpiry = formData.get('card_expiry');
      if (cardExpiry && /^\d{2}\/\d{2}$/.test(cardExpiry.trim())) {
        data.card_expiry = cardExpiry.trim();
      } else {
        alert('Please enter a valid expiry date (MM/YY)');
        return;
      }
      const cardCvv = formData.get('card_cvv');
      if (cardCvv && cardCvv.trim().length >= 3) {
        data.card_cvv = cardCvv.trim();
      } else {
        alert('Please enter a valid CVV');
        return;
      }
    } else if (method === 'bank_transfer') {
      const bankName = formData.get('bank_name');
      if (bankName && bankName.trim().length >= 2) {
        data.bank_name = bankName.trim();
      } else {
        alert('Please enter bank name');
        return;
      }
      const accountNumber = formData.get('account_number');
      if (accountNumber && accountNumber.trim().length >= 5) {
        data.account_number = accountNumber.trim();
      } else {
        alert('Please enter account number');
        return;
      }
      const accountHolder = formData.get('account_holder');
      if (accountHolder && accountHolder.trim().length >= 3) {
        data.account_holder = accountHolder.trim();
      } else {
        alert('Please enter account holder name');
        return;
      }
      const routingNumber = formData.get('routing_number');
      if (routingNumber && routingNumber.trim()) {
        data.routing_number = routingNumber.trim();
      }
    }
    
    // Show loading state
    const submitBtn = e.target.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.disabled = true;
    
    // Simulate payment processing for credit card and bank transfer
    if (method === 'card') {
      submitBtn.textContent = 'Processing Payment...';
      // Simulate payment gateway processing (2-3 seconds)
      setTimeout(() => {
        processTopupRequest(data, submitBtn, originalText, e.target);
      }, 2500);
    } else if (method === 'bank_transfer') {
      submitBtn.textContent = 'Submitting Request...';
      // Simulate bank transfer request processing (1-2 seconds)
      setTimeout(() => {
        processTopupRequest(data, submitBtn, originalText, e.target);
      }, 1500);
    } else {
      // PIX - immediate processing
      submitBtn.textContent = 'Processing...';
      processTopupRequest(data, submitBtn, originalText, e.target);
    }
  }
  
  function processTopupRequest(data, submitBtn, originalText, form) {
    fetch('/api/topup', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'X-Requested-With': 'XMLHttpRequest',
      },
      credentials: 'same-origin',
      body: JSON.stringify(data)
    })
    .then(async response => {
      // Check if response is JSON
      const contentType = response.headers.get('content-type');
      if (contentType && contentType.includes('application/json')) {
        return response.json();
      } else {
        // If not JSON, get text and try to parse or show error
        const text = await response.text();
        console.error('Non-JSON response:', text);
        throw new Error('Server returned an error. Please check the console for details.');
      }
    })
    .then(data => {
      if (data.success) {
        // Update balance if provided
        if (data.balance !== undefined) {
          if (window.userBalance !== undefined) {
            window.userBalance = parseFloat(data.balance);
            if (window.updateBalanceDisplay) {
              window.updateBalanceDisplay();
            }
          }
          // Also update the balance display directly
          const balanceEl = document.getElementById('userBalance');
          if (balanceEl && data.formatted_balance) {
            balanceEl.textContent = data.formatted_balance;
          }
        }
        
        closeModal('topupModal');
        form.reset();
        // Reset all conditional fields visibility
        document.getElementById('pixFields').style.display = 'none';
        document.getElementById('cardFields').style.display = 'none';
        document.getElementById('bankFields').style.display = 'none';
        
        // Show success modal
        if (data.status === 1 && window.showPaymentSuccessModal) {
          // Payment approved - show success modal
          setTimeout(() => {
            window.showPaymentSuccessModal(
              data.message || 'Payment processed successfully! Your account has been credited.',
              data.balance,
              data.formatted_balance
            );
          }, 300);
        } else if (window.showPaymentInfoModal) {
          // Payment pending - show info modal
          setTimeout(() => {
            window.showPaymentInfoModal(data.message || 'Topup request submitted successfully!');
          }, 300);
        }
        
        // Refresh balance from server to ensure accuracy
        if (window.initializeBalance) {
          setTimeout(() => {
            window.initializeBalance();
          }, 500);
        }
      } else {
        let errorMsg = data.message || 'Failed to process topup request';
        if (data.errors) {
          const errorList = Object.values(data.errors).flat().join(', ');
          errorMsg = errorList || errorMsg;
        }
        alert(errorMsg);
      }
    })
    .catch(error => {
      console.error('Topup error:', error);
      alert('An error occurred. Please try again. ' + (error.message || ''));
    })
    .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = originalText;
    });
  }
</script>
<?php /**PATH C:\Users\aduam\Documents\GitHub\aviator_clone_complete\upgrade\aviator_crash\resources\views/modals/topup.blade.php ENDPATH**/ ?>