<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title>Admin Login</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #f1f5f9;
    }

    .login-container {
      width: 100%;
      max-width: 420px;
      padding: 20px;
    }

    .login-card {
      background: rgba(30, 41, 59, 0.9);
      border: 1px solid #334155;
      border-radius: 16px;
      padding: 40px;
      box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
    }

    .logo {
      text-align: center;
      margin-bottom: 30px;
      font-size: 32px;
      font-weight: 700;
      color: #22c55e;
    }

    .logo-icon {
      display: block;
      margin-bottom: 10px;
      font-size: 48px;
    }

    .login-title {
      text-align: center;
      font-size: 24px;
      font-weight: 600;
      margin-bottom: 30px;
      color: #f1f5f9;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: #94a3b8;
      font-size: 14px;
    }

    .form-input {
      width: 100%;
      padding: 14px 16px;
      background: #0f172a;
      border: 2px solid #334155;
      border-radius: 8px;
      color: #f1f5f9;
      font-size: 15px;
      transition: all 0.2s;
    }

    .form-input:focus {
      outline: none;
      border-color: #22c55e;
    }

    .form-input::placeholder {
      color: #475569;
    }

    .btn-login {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
      color: #ffffff;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.2s;
      margin-top: 10px;
    }

    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 20px -5px rgba(34, 197, 94, 0.4);
    }

    .alert {
      padding: 14px;
      border-radius: 8px;
      margin-bottom: 20px;
      font-size: 14px;
    }

    .alert-error {
      background: rgba(239, 68, 68, 0.1);
      color: #ef4444;
      border: 1px solid #ef4444;
    }

    .back-to-game {
      text-align: center;
      margin-top: 20px;
      color: #94a3b8;
    }

    .back-to-game a {
      color: #22c55e;
      text-decoration: none;
      font-weight: 500;
    }

    .back-to-game a:hover {
      text-decoration: underline;
    }

    @media (max-width: 480px) {
      .login-card {
        padding: 30px 20px;
      }

      .login-title {
        font-size: 20px;
      }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="login-card">
      <div class="logo">
        <span class="logo-icon">🔐</span>
        Admin Panel
      </div>
      
      <?php if(session('error')): ?>
        <div class="alert alert-error">
          <?php echo e(session('error')); ?>

        </div>
      <?php endif; ?>

      <h1 class="login-title">Admin Login</h1>

      <form method="POST" action="<?php echo e(route('admin.login.post')); ?>">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
          <label for="email" class="form-label">Email Address</label>
          <input 
            type="email" 
            id="email" 
            name="email" 
            class="form-input" 
            placeholder="admin@example.com"
            value="<?php echo e(old('email')); ?>"
            required
            autofocus
          >
        </div>

        <div class="form-group">
          <label for="password" class="form-label">Password</label>
          <input 
            type="password" 
            id="password" 
            name="password" 
            class="form-input" 
            placeholder="•••••••••"
            required
          >
        </div>

        <button type="submit" class="btn-login">
          Sign In as Admin
        </button>
      </form>

      <div class="back-to-game">
        <a href="<?php echo e(route('game')); ?>">← Back to Game</a>
      </div>
    </div>
  </div>
</body>
</html>
<?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>