<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\LogoutController;
use Illuminate\Support\Facades\Route;

// Authentication Routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'login']);
    Route::get('/register', [RegisterController::class, 'showRegisterForm'])->name('register');
    Route::post('/register', [RegisterController::class, 'register']);
});

Route::post('/logout', [LogoutController::class, 'logout'])->name('logout')->middleware('auth');

// Protected Game Route
Route::middleware('auth')->group(function () {
    Route::get('/', function () {
        return view('game');
    })->name('game');

    // API Routes for Balance
    Route::prefix('api')->group(function () {
        Route::get('/balance', [\App\Http\Controllers\Api\BalanceController::class, 'getBalance'])->name('api.balance');
        Route::post('/balance/deduct', [\App\Http\Controllers\Api\BalanceController::class, 'deductBalance'])->name('api.balance.deduct');
        Route::post('/balance/add', [\App\Http\Controllers\Api\BalanceController::class, 'addBalance'])->name('api.balance.add');
        Route::post('/topup', [\App\Http\Controllers\TopupController::class, 'store'])->name('api.topup');
        Route::post('/withdraw', [\App\Http\Controllers\WithdrawController::class, 'store'])->name('api.withdraw');
        Route::get('/history', [\App\Http\Controllers\HistoryController::class, 'index'])->name('api.history');
        Route::post('/game-round', [\App\Http\Controllers\Api\GameRoundController::class, 'storeRound'])->name('api.game-round.store');
        Route::get('/flew-away-multipliers', [\App\Http\Controllers\Api\GameRoundController::class, 'getFlewAwayMultipliers'])->name('api.flew-away-multipliers');
    });
    
    // Profile routes
    Route::post('/profile/update', [\App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
});

// Admin Authentication Routes (no auth middleware)
Route::prefix('admin')->group(function () {
    Route::get('/login', [\App\Http\Controllers\Admin\AuthController::class, 'showLoginForm'])->name('admin.login');
    Route::post('/login', [\App\Http\Controllers\Admin\AuthController::class, 'login'])->name('admin.login.post');
    Route::post('/logout', [\App\Http\Controllers\Admin\AuthController::class, 'logout'])->name('admin.logout');
});

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->group(function () {
    Route::get('/', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('admin.dashboard');
    
    // User Management
    Route::prefix('users')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\UserManagementController::class, 'index'])->name('admin.users');
        Route::get('/{user}', [\App\Http\Controllers\Admin\UserManagementController::class, 'show'])->name('admin.users.show');
        Route::put('/{user}', [\App\Http\Controllers\Admin\UserManagementController::class, 'update'])->name('admin.users.update');
        Route::patch('/{user}/ban', [\App\Http\Controllers\Admin\UserManagementController::class, 'ban'])->name('admin.users.ban');
        Route::delete('/{user}', [\App\Http\Controllers\Admin\UserManagementController::class, 'destroy'])->name('admin.users.delete');
        Route::post('/{user}/balance', [\App\Http\Controllers\Admin\UserManagementController::class, 'updateBalance'])->name('admin.users.balance');
    });
    
    // Finances
    Route::prefix('finances')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\FinanceController::class, 'index'])->name('admin.finances');
        Route::patch('/deposit/{id}/approve', [\App\Http\Controllers\Admin\FinanceController::class, 'approveDeposit'])->name('admin.finances.deposit.approve');
        Route::patch('/deposit/{id}/reject', [\App\Http\Controllers\Admin\FinanceController::class, 'rejectDeposit'])->name('admin.finances.deposit.reject');
        Route::patch('/withdrawal/{id}/approve', [\App\Http\Controllers\Admin\FinanceController::class, 'approveWithdrawal'])->name('admin.finances.withdrawal.approve');
        Route::patch('/withdrawal/{id}/reject', [\App\Http\Controllers\Admin\FinanceController::class, 'rejectWithdrawal'])->name('admin.finances.withdrawal.reject');
    });
    
    // Statistics
    Route::prefix('statistics')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\StatisticsController::class, 'index'])->name('admin.statistics');
        Route::get('/game-history', [\App\Http\Controllers\Admin\StatisticsController::class, 'gameHistory'])->name('admin.statistics.game-history');
    });
    
    // Settings
    Route::prefix('settings')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('admin.settings');
        Route::put('/', [\App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('admin.settings.update');
    });
});
