<div class="modal" id="withdrawModal">
  <div class="modal-overlay"></div>
  <div class="modal-container">
    <div class="modal-header">
      <h2>Withdraw Funds</h2>
      <button class="modal-close" onclick="closeModal('withdrawModal')">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </div>
    <div class="modal-body">
      <div class="balance-info-box">
        <span class="label">Available Balance:</span>
        <span class="value">R$ <span id="withdrawBalance">{{ auth()->user()->formatted_balance }}</span></span>
      </div>
      
      <form id="withdrawForm" onsubmit="handleWithdraw(event)">
        @csrf
        <div class="form-group">
          <label for="withdrawAmount">Withdrawal Amount (R$)</label>
          <input type="number" id="withdrawAmount" name="amount" min="20" step="0.01" placeholder="Enter amount" required>
          <small class="form-hint">Minimum: R$ 20.00</small>
        </div>
        
        <div class="form-group">
          <label for="withdrawMethod">Withdrawal Method</label>
          <select id="withdrawMethod" name="method" required>
            <option value="">Select withdrawal method</option>
            <option value="pix">PIX</option>
            <option value="bank_transfer">Bank Transfer</option>
          </select>
        </div>
        
        <div class="form-group" id="pixWithdrawFields" style="display: none;">
          <label for="withdrawPixKey">PIX Key</label>
          <input type="text" id="withdrawPixKey" name="pix_key" placeholder="Enter your PIX key">
          <label for="pixType" style="margin-top: 10px;">PIX Key Type</label>
          <select id="pixType" name="pix_type">
            <option value="document">CPF/CNPJ</option>
            <option value="email">Email</option>
            <option value="phone">Phone</option>
            <option value="random">Random Key</option>
          </select>
        </div>
        
        <div class="form-group" id="bankFields" style="display: none;">
          <label for="bankName">Bank Name</label>
          <input type="text" id="bankName" name="bank_name" placeholder="Enter bank name">
          <label for="accountNumber" style="margin-top: 10px;">Account Number</label>
          <input type="text" id="accountNumber" name="account_number" placeholder="Enter account number">
          <label for="accountHolder" style="margin-top: 10px;">Account Holder Name</label>
          <input type="text" id="accountHolder" name="account_holder" placeholder="Enter account holder name">
        </div>
        
        <div class="quick-amounts">
          <span class="quick-amount-label">Quick Amount:</span>
          <button type="button" class="quick-btn" onclick="setWithdrawAmount(100)">R$ 100</button>
          <button type="button" class="quick-btn" onclick="setWithdrawAmount(500)">R$ 500</button>
          <button type="button" class="quick-btn" onclick="setWithdrawAmount(1000)">R$ 1,000</button>
          <button type="button" class="quick-btn" onclick="setWithdrawAll()">All</button>
        </div>
        
        <div class="modal-footer">
          <button type="button" class="btn-secondary" onclick="closeModal('withdrawModal')">Cancel</button>
          <button type="submit" class="btn-primary">Request Withdrawal</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  function setWithdrawAmount(amount) {
    document.getElementById('withdrawAmount').value = amount;
  }
  
  function setWithdrawAll() {
    const balance = parseFloat(document.getElementById('withdrawBalance').textContent.replace(/,/g, ''));
    document.getElementById('withdrawAmount').value = balance.toFixed(2);
  }
  
  // Show/hide fields based on withdrawal method
  document.getElementById('withdrawMethod')?.addEventListener('change', function(e) {
    const pixFields = document.getElementById('pixWithdrawFields');
    const bankFields = document.getElementById('bankFields');
    
    if (e.target.value === 'pix') {
      pixFields.style.display = 'block';
      bankFields.style.display = 'none';
      document.getElementById('withdrawPixKey').required = true;
    } else if (e.target.value === 'bank_transfer') {
      pixFields.style.display = 'none';
      bankFields.style.display = 'block';
      document.getElementById('withdrawPixKey').required = false;
    } else {
      pixFields.style.display = 'none';
      bankFields.style.display = 'none';
    }
  });
  
  function handleWithdraw(e) {
    e.preventDefault();
    const formData = new FormData(e.target);
    const data = {};
    
    // Only include relevant fields based on selected withdrawal method
    const method = formData.get('method');
    const amount = parseFloat(formData.get('amount'));
    const balance = parseFloat(document.getElementById('withdrawBalance').textContent.replace(/,/g, ''));
    
    if (amount > balance) {
      alert('Insufficient balance!');
      return;
    }
    
    data.amount = amount;
    data.method = method;
    
    // Validate and include fields relevant to the selected withdrawal method
    if (method === 'pix') {
      const pixKey = formData.get('pix_key');
      if (pixKey && pixKey.trim()) {
        data.pix_key = pixKey.trim();
      } else {
        alert('Please enter your PIX key');
        return;
      }
      const pixType = formData.get('pix_type');
      if (pixType) {
        data.pix_type = pixType;
      }
    } else if (method === 'bank_transfer') {
      const bankName = formData.get('bank_name');
      if (bankName && bankName.trim().length >= 2) {
        data.bank_name = bankName.trim();
      } else {
        alert('Please enter bank name');
        return;
      }
      const accountNumber = formData.get('account_number');
      if (accountNumber && accountNumber.trim().length >= 5) {
        data.account_number = accountNumber.trim();
      } else {
        alert('Please enter account number');
        return;
      }
      const accountHolder = formData.get('account_holder');
      if (accountHolder && accountHolder.trim().length >= 3) {
        data.account_holder = accountHolder.trim();
      } else {
        alert('Please enter account holder name');
        return;
      }
    }
    
    const submitBtn = e.target.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.disabled = true;
    submitBtn.textContent = 'Processing Request...';
    
    // Simulate withdrawal request processing
    setTimeout(() => {
      processWithdrawRequest(data, submitBtn, originalText, e.target);
    }, 1500);
  }
  
  function processWithdrawRequest(data, submitBtn, originalText, form) {
    fetch('/api/withdraw', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'X-Requested-With': 'XMLHttpRequest',
      },
      credentials: 'same-origin',
      body: JSON.stringify(data)
    })
    .then(async response => {
      // Check if response is JSON
      const contentType = response.headers.get('content-type');
      if (contentType && contentType.includes('application/json')) {
        return response.json();
      } else {
        // If not JSON, get text and try to parse or show error
        const text = await response.text();
        console.error('Non-JSON response:', text);
        throw new Error('Server returned an error. Please check the console for details.');
      }
    })
    .then(data => {
      if (data.success) {
        alert('Withdrawal request submitted successfully! It will be processed within 24-48 hours.');
        closeModal('withdrawModal');
        form.reset();
        // Reset conditional fields visibility
        document.getElementById('pixWithdrawFields').style.display = 'none';
        document.getElementById('bankFields').style.display = 'none';
        // Update balance display
        if (data.balance !== undefined) {
          if (window.userBalance !== undefined) {
            window.userBalance = parseFloat(data.balance);
            if (window.updateBalanceDisplay) {
              window.updateBalanceDisplay();
            }
          }
        }
        if (window.initializeBalance) {
          setTimeout(() => {
            window.initializeBalance();
          }, 500);
        }
      } else {
        let errorMsg = data.message || 'Failed to process withdrawal request';
        if (data.errors) {
          const errorList = Object.values(data.errors).flat().join(', ');
          errorMsg = errorList || errorMsg;
        }
        alert(errorMsg);
      }
    })
    .catch(error => {
      console.error('Withdraw error:', error);
      alert('An error occurred. Please try again. ' + (error.message || ''));
    })
    .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = originalText;
    });
  }
</script>
