<div class="user-menu-container">
  <div class="menu-icon" id="userMenuIcon">
      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
        <path d="M3 12h18M3 6h18M3 18h18"/>
      </svg>
  </div>
  <div class="user-menu-dropdown" id="userMenuDropdown">
    <!-- User Profile Section -->
    <div class="user-profile-section">
      <div class="user-avatar-container">
        <div class="user-avatar" id="userAvatar" style="background-image: url('{{ auth()->user()->avatar ?? 'https://ui-avatars.com/api/?name=' . urlencode(auth()->user()->name) . '&background=random' }}')">
        </div>
        <div class="user-info">
          <div class="user-username">{{ auth()->user()->name }}</div>
        </div>
        <button class="change-avatar-btn" onclick="event.preventDefault(); openModal('avatarModal');">
          <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
            <circle cx="12" cy="7" r="4"/>
          </svg>
        </button>
      </div>
    </div>
    
    <!-- Settings Toggles -->
    <div class="settings-section">
      @include('components.header.settings-toggle', ['icon' => 'sound', 'label' => 'Sound', 'id' => 'soundToggle'])
      @include('components.header.settings-toggle', ['icon' => 'music', 'label' => 'Music', 'id' => 'musicToggle'])
      @include('components.header.settings-toggle', ['icon' => 'animation', 'label' => 'Animation', 'id' => 'animationToggle'])
    </div>
    
    <!-- Menu Items -->
    <div class="menu-items-section">
      @include('components.header.menu-item', ['icon' => 'plus', 'label' => 'Topup Account', 'modal' => 'topupModal'])
      @include('components.header.menu-item', ['icon' => 'user', 'label' => 'Update Profile', 'modal' => 'profileModal'])
      @include('components.header.menu-item', ['icon' => 'withdraw', 'label' => 'Withdraw', 'modal' => 'withdrawModal'])
      @include('components.header.menu-item', ['icon' => 'history', 'label' => 'My Bet History', 'modal' => 'historyModal'])
      @include('components.header.menu-item', ['icon' => 'help', 'label' => 'How To Play', 'modal' => 'howToPlayModal'])
      @include('components.header.menu-item', ['icon' => 'rules', 'label' => 'Game Rules', 'modal' => 'gameRulesModal'])
      <div class="menu-divider"></div>
      @include('components.header.menu-item', ['icon' => 'logout', 'label' => 'Logout', 'modal' => 'logoutModal', 'isDanger' => true])
    </div>
  </div>
</div>
