@extends('layouts.admin')

@section('title', "User: {$user->name}")

@section('content')
  <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 20px; margin-bottom: 30px;">
    <!-- User Info Card -->
    <div class="card">
      <div class="card-title"><i class="fas fa-user-circle"></i> User Information</div>
      <div style="display: grid; grid-template-columns: auto 1fr; gap: 10px;">
        <strong><i class="fas fa-id-card"></i> ID:</strong> #{{ $user->id }}
        <strong><i class="fas fa-user"></i> Name:</strong> {{ $user->name }}
        <strong><i class="fas fa-envelope"></i> Email:</strong> {{ $user->email }}
        <strong><i class="fas fa-phone"></i> Phone:</strong> {{ $user->phone ?? '-' }}
        <strong><i class="fas fa-address-card"></i> CPF:</strong> {{ $user->cpf ?? '-' }}
        <strong><i class="fas fa-wallet"></i> Balance:</strong> R$ {{ number_format($user->balance, 2, ',', '.') }}
        <strong><i class="fas fa-shield-alt"></i> Role:</strong> {{ $user->role_id == 1 ? 'Admin' : 'User' }}
        <strong><i class="fas fa-signal"></i> Status:</strong> {{ $user->status ? 'Active' : 'Inactive' }}
        <strong><i class="fas fa-ban"></i> Banned:</strong> {{ $user->banned ? 'Yes' : 'No' }}
        <strong><i class="fas fa-calendar-alt"></i> Joined:</strong> {{ $user->created_at->format('M d, Y H:i') }}
        <strong><i class="fas fa-clock"></i> Last Activity:</strong> {{ $user->last_activity ? $user->last_activity->format('M d, Y H:i') : 'Never' }}
      </div>
    </div>

    <!-- Update Balance -->
    <div class="card">
      <div class="card-title"><i class="fas fa-wallet"></i> Update Balance</div>
      <form action="{{ route('admin.users.balance', $user->id) }}" method="POST">
        @csrf
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;">Amount (R$)</label>
          <input type="number" step="0.01" name="amount" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;">Action</label>
          <select name="type" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="add">Add to Balance</option>
            <option value="subtract">Subtract from Balance</option>
          </select>
        </div>
        <button type="submit" class="btn btn-primary"><i class="fas fa-sync-alt"></i> Update Balance</button>
      </form>
    </div>

    <!-- Update User Info -->
    <div class="card">
      <div class="card-title"><i class="fas fa-user-edit"></i> Update User</div>
      <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-user"></i> Name</label>
          <input type="text" name="name" value="{{ $user->name }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-envelope"></i> Email</label>
          <input type="email" name="email" value="{{ $user->email }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-shield-alt"></i> Role</label>
          <select name="role_id" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="0" {{ $user->role_id == 0 ? 'selected' : '' }}>User</option>
            <option value="1" {{ $user->role_id == 1 ? 'selected' : '' }}>Admin</option>
          </select>
        </div>
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-signal"></i> Status</label>
          <select name="status" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="1" {{ $user->status ? 'selected' : '' }}>Active</option>
            <option value="0" {{ !$user->status ? 'selected' : '' }}>Inactive</option>
          </select>
        </div>
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-ban"></i> Banned</label>
          <select name="banned" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="0" {{ !$user->banned ? 'selected' : '' }}>No</option>
            <option value="1" {{ $user->banned ? 'selected' : '' }}>Yes</option>
          </select>
        </div>
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-key"></i> New Password (leave blank to keep current)</label>
          <input type="password" name="password" style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Update User</button>
      </form>
    </div>
  </div>

  <!-- Deposits -->
  <div class="card">
    <div class="card-title"><i class="fas fa-download"></i> User Deposits</div>
    <div class="table-container">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Date</th>
          </tr>
        </thead>
        <tbody>
          @forelse($deposits as $deposit)
            <tr>
              <td>#{{ $deposit->id }}</td>
              <td>R$ {{ number_format($deposit->amount, 2, ',', '.') }}</td>
              <td>
                @if($deposit->status == 1)
                  <span class="status-badge status-success">Approved</span>
                @elseif($deposit->status == 0)
                  <span class="status-badge status-pending">Pending</span>
                @else
                  <span class="status-badge status-error">Rejected</span>
                @endif
              </td>
              <td>{{ $deposit->created_at->format('M d, Y H:i') }}</td>
            </tr>
          @empty
            <tr>
              <td colspan="4">No deposits found</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  <!-- Orders -->
  <div class="card">
    <div class="card-title"><i class="fas fa-list"></i> User Orders</div>
    <div class="table-container">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Date</th>
          </tr>
        </thead>
        <tbody>
          @forelse($orders as $order)
            <tr>
              <td>#{{ $order->id }}</td>
              <td>
                @if($order->type == 'win')
                  <span class="status-badge status-success">Win</span>
                @else
                  <span class="status-badge status-error">Loss</span>
                @endif
              </td>
              <td>R$ {{ number_format($order->amount, 2, ',', '.') }}</td>
              <td>
                @if($order->status == 1)
                  <span class="status-badge status-success">Completed</span>
                @else
                  <span class="status-badge status-pending">Pending</span>
                @endif
              </td>
              <td>{{ $order->created_at->format('M d, Y H:i') }}</td>
            </tr>
          @empty
            <tr>
              <td colspan="5">No orders found</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
@endsection
