@extends('layouts.admin')

@section('title', 'Settings')

@section('content')
  <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 20px; margin-bottom: 30px;">
    <!-- General Settings -->
    <div class="card">
      <div class="card-title"><i class="fas fa-cogs"></i> General Settings</div>
      <form action="{{ route('admin.settings.update') }}" method="POST">
        @csrf
        @method('PUT')
        
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-globe"></i> Site Name</label>
          <input type="text" name="site_name" value="{{ $settings['site_name'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-dollar-sign"></i> Default Currency</label>
          <input type="text" name="default_currency" value="{{ $settings['default_currency'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-tools"></i> Maintenance Mode</label>
          <select name="maintenance_mode" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="0" {{ !$settings['maintenance_mode'] ? 'selected' : '' }}>Disabled</option>
            <option value="1" {{ $settings['maintenance_mode'] ? 'selected' : '' }}>Enabled</option>
          </select>
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-user-plus"></i> Registration Enabled</label>
          <select name="registration_enabled" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="1" {{ $settings['registration_enabled'] ? 'selected' : '' }}>Enabled</option>
            <option value="0" {{ !$settings['registration_enabled'] ? 'selected' : '' }}>Disabled</option>
          </select>
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Settings</button>
      </form>
    </div>

    <!-- Financial Settings -->
    <div class="card">
      <div class="card-title"><i class="fas fa-coins"></i> Financial Settings</div>
      <form action="{{ route('admin.settings.update') }}" method="POST">
        @csrf
        @method('PUT')
        
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-arrow-down"></i> Minimum Deposit (R$)</label>
          <input type="number" step="0.01" name="min_deposit" value="{{ $settings['min_deposit'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-arrow-up"></i> Maximum Deposit (R$)</label>
          <input type="number" step="0.01" name="max_deposit" value="{{ $settings['max_deposit'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-download"></i> Minimum Withdrawal (R$)</label>
          <input type="number" step="0.01" name="min_withdrawal" value="{{ $settings['min_withdrawal'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-upload"></i> Maximum Withdrawal (R$)</label>
          <input type="number" step="0.01" name="max_withdrawal" value="{{ $settings['max_withdrawal'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-percentage"></i> Withdrawal Fee (%)</label>
          <input type="number" step="0.01" name="withdrawal_fee" value="{{ $settings['withdrawal_fee'] }}" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Settings</button>
      </form>
    </div>
  </div>

  <div class="card">
    <div class="card-title"><i class="fas fa-info-circle"></i> Current Configuration</div>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
      <div>
        <strong style="display: block; margin-bottom: 5px;">Site Name:</strong>
        <span>{{ $settings['site_name'] }}</span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Currency:</strong>
        <span>{{ $settings['default_currency'] }}</span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Maintenance Mode:</strong>
        <span class="status-badge {{ $settings['maintenance_mode'] ? 'status-error' : 'status-success' }}">
          {{ $settings['maintenance_mode'] ? 'Enabled' : 'Disabled' }}
        </span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Registration:</strong>
        <span class="status-badge {{ $settings['registration_enabled'] ? 'status-success' : 'status-error' }}">
          {{ $settings['registration_enabled'] ? 'Enabled' : 'Disabled' }}
        </span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Min Deposit:</strong>
        <span>R$ {{ number_format($settings['min_deposit'], 2, ',', '.') }}</span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Max Deposit:</strong>
        <span>R$ {{ number_format($settings['max_deposit'], 2, ',', '.') }}</span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Min Withdrawal:</strong>
        <span>R$ {{ number_format($settings['min_withdrawal'], 2, ',', '.') }}</span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Max Withdrawal:</strong>
        <span>R$ {{ number_format($settings['max_withdrawal'], 2, ',', '.') }}</span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Withdrawal Fee:</strong>
        <span>{{ $settings['withdrawal_fee'] }}%</span>
      </div>
    </div>
  </div>
@endsection
