@extends('layouts.admin')

@section('title', 'Finances')

@section('content')
  <!-- Finance Stats -->
  <div class="stats-grid">
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-download"></i> Total Deposits</div>
      <div class="stat-value">R$ {{ number_format($stats['total_deposits'], 2, ',', '.') }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-upload"></i> Total Withdrawals</div>
      <div class="stat-value">R$ {{ number_format($stats['total_withdrawals'], 2, ',', '.') }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-clock"></i> Pending Deposits</div>
      <div class="stat-value">R$ {{ number_format($stats['pending_deposits'], 2, ',', '.') }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-hourglass-half"></i> Pending Withdrawals</div>
      <div class="stat-value">R$ {{ number_format($stats['pending_withdrawals'], 2, ',', '.') }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-chart-line"></i> Net Profit</div>
      <div class="stat-value">R$ {{ number_format($stats['net_profit'], 2, ',', '.') }}</div>
    </div>
  </div>

  <!-- Tabbed Table Card -->
  <div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
      <button class="tab-btn active" data-tab="deposits" onclick="switchTab('deposits', this)">
        <i class="fas fa-money-bill-wave"></i> Deposits
      </button>
      <button class="tab-btn" data-tab="withdrawals" onclick="switchTab('withdrawals', this)">
        <i class="fas fa-money-check-alt"></i> Withdrawals
      </button>
    </div>

    <!-- Deposits Tab -->
    <div id="deposits" class="tab-content active">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
              <th>Date</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            @forelse($deposits as $deposit)
              <tr>
                <td>#{{ $deposit->id }}</td>
                <td>
                  <div>{{ $deposit->user_name }}</div>
                  <small style="color: #888;">{{ $deposit->user_email }}</small>
                </td>
                <td>R$ {{ number_format($deposit->amount, 2, ',', '.') }}</td>
                <td>
                  @if($deposit->status == 1)
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  @elseif($deposit->status == 0)
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  @else
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  @endif
                </td>
                <td>{{ $deposit->created_at->format('M d, Y H:i') }}</td>
                <td>
                  @if($deposit->status == 0)
                    <form action="{{ route('admin.finances.deposit.approve', $deposit->id) }}" method="POST" style="display: inline;">
                      @csrf
                      @method('PATCH')
                      <button type="submit" class="btn btn-sm btn-success"><i class="fas fa-check"></i></button>
                    </form>
                    <form action="{{ route('admin.finances.deposit.reject', $deposit->id) }}" method="POST" style="display: inline;">
                      @csrf
                      @method('PATCH')
                      <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></button>
                    </form>
                  @endif
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="6">No deposits found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      
      @if($deposits->hasPages())
        <div style="margin-top: 20px; text-align: center;">
          {{ $deposits->links() }}
        </div>
      @endif
    </div>

    <!-- Withdrawals Tab -->
    <div id="withdrawals" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
              <th>Date</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            @forelse($withdrawals as $withdrawal)
              <tr>
                <td>#{{ $withdrawal->id }}</td>
                <td>
                  <div>{{ $withdrawal->user_name }}</div>
                  <small style="color: #888;">{{ $withdrawal->user_email }}</small>
                </td>
                <td>R$ {{ number_format($withdrawal->amount, 2, ',', '.') }}</td>
                <td>
                  @if($withdrawal->status == 1)
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  @elseif($withdrawal->status == 0)
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  @else
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  @endif
                </td>
                <td>{{ $withdrawal->created_at->format('M d, Y H:i') }}</td>
                <td>
                  @if($withdrawal->status == 0)
                    <form action="{{ route('admin.finances.withdrawal.approve', $withdrawal->id) }}" method="POST" style="display: inline;">
                      @csrf
                      @method('PATCH')
                      <button type="submit" class="btn btn-sm btn-success"><i class="fas fa-check"></i></button>
                    </form>
                    <form action="{{ route('admin.finances.withdrawal.reject', $withdrawal->id) }}" method="POST" style="display: inline;">
                      @csrf
                      @method('PATCH')
                      <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></button>
                    </form>
                  @endif
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="6">No withdrawals found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      
      @if($withdrawals->hasPages())
        <div style="margin-top: 20px; text-align: center;">
          {{ $withdrawals->links() }}
        </div>
      @endif
    </div>
  </div>

  <script>
    function switchTab(tabId, button) {
      document.querySelectorAll('.tab-content').forEach(function(content) {
        content.classList.remove('active');
      });

      document.querySelectorAll('.tab-btn').forEach(function(btn) {
        btn.classList.remove('active');
      });

      document.getElementById(tabId).classList.add('active');
      button.classList.add('active');
    }
  </script>
@endsection
