@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
  <!-- Stats Grid -->
  <div class="stats-grid">
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-users"></i> Total Users</div>
      <div class="stat-value">{{ $stats['total_users'] }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-user-check"></i> Active Users (24h)</div>
      <div class="stat-value">{{ $stats['active_users'] }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-download"></i> Total Deposits</div>
      <div class="stat-value">R$ {{ number_format($stats['total_deposits'], 2, ',', '.') }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-upload"></i> Total Withdrawals</div>
      <div class="stat-value">R$ {{ number_format($stats['total_withdrawals'], 2, ',', '.') }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-clock"></i> Pending Deposits</div>
      <div class="stat-value">{{ $stats['pending_deposits'] }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-hourglass-half"></i> Pending Withdrawals</div>
      <div class="stat-value">{{ $stats['pending_withdrawals'] }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-gamepad"></i> Total Game Rounds</div>
      <div class="stat-value">{{ $stats['total_game_rounds'] }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-chart-line"></i> Total Revenue</div>
      <div class="stat-value">R$ {{ number_format($stats['total_revenue'], 2, ',', '.') }}</div>
    </div>
  </div>

  <!-- Tabbed Table Card -->
  <div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
      <button class="tab-btn active" data-tab="recent-users" onclick="switchTab('recent-users', this)">
        <i class="fas fa-users"></i> Recent Users
      </button>
      <button class="tab-btn" data-tab="recent-deposits" onclick="switchTab('recent-deposits', this)">
        <i class="fas fa-money-bill-wave"></i> Recent Deposits
      </button>
      <button class="tab-btn" data-tab="recent-withdrawals" onclick="switchTab('recent-withdrawals', this)">
        <i class="fas fa-money-check-alt"></i> Recent Withdrawals
      </button>
    </div>

    <!-- Recent Users Tab -->
    <div id="recent-users" class="tab-content active">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>Name</th>
              <th>Email</th>
              <th>Joined</th>
            </tr>
          </thead>
          <tbody>
            @forelse($recent_users as $user)
              <tr>
                <td>#{{ $user->id }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>{{ $user->created_at->format('M d, Y') }}</td>
              </tr>
            @empty
              <tr>
                <td colspan="4">No users found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>

    <!-- Recent Deposits Tab -->
    <div id="recent-deposits" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            @forelse($recent_deposits as $deposit)
              <tr>
                <td>#{{ $deposit->id }}</td>
                <td>{{ $deposit->name }}</td>
                <td>R$ {{ number_format($deposit->amount, 2, ',', '.') }}</td>
                <td>
                  @if($deposit->status == 1)
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  @elseif($deposit->status == 0)
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  @else
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  @endif
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="4">No deposits found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>

    <!-- Recent Withdrawals Tab -->
    <div id="recent-withdrawals" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            @forelse($recent_withdrawals as $withdrawal)
              <tr>
                <td>#{{ $withdrawal->id }}</td>
                <td>{{ $withdrawal->name }}</td>
                <td>R$ {{ number_format($withdrawal->amount, 2, ',', '.') }}</td>
                <td>
                  @if($withdrawal->status == 1)
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  @elseif($withdrawal->status == 0)
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  @else
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  @endif
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="4">No withdrawals found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <script>
    function switchTab(tabId, button) {
      document.querySelectorAll('.tab-content').forEach(function(content) {
        content.classList.remove('active');
      });

      document.querySelectorAll('.tab-btn').forEach(function(btn) {
        btn.classList.remove('active');
      });

      document.getElementById(tabId).classList.add('active');
      button.classList.add('active');
    }
  </script>
@endsection
