<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>Admin Login</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    :root {
      --brand-red: #e60026;
      --brand-green: #12DF38;
      --brand-blue: #3b82f6;
      --brand-purple: #a855f7;
      --brand-yellow: #eab308;
      --bg-darker: #0a0a0a;
      --bg-dark: #1a1a1a;
      --bg-med: #262626;
      --bg-light: #2d2d2d;
      --text-primary: #ffffff;
      --text-secondary: #888888;
      --border-color: #3a3a3a;
      --shadow: rgba(0, 0, 0, 0.3);
    }

    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      background: linear-gradient(135deg, var(--bg-darker) 0%, var(--bg-dark) 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--text-primary);
      padding: 20px;
    }

    .login-wrapper {
      width: 100%;
      max-width: 480px;
    }

    .login-card {
      background: var(--bg-dark);
      border-radius: 24px;
      padding: 48px;
      box-shadow: 0 25px 50px -12px var(--shadow);
      position: relative;
      overflow: hidden;
      border: 1px solid var(--border-color);
    }

    .login-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 6px;
      background: linear-gradient(90deg, var(--brand-green) 0%, var(--brand-red) 100%);
    }

    .logo-container {
      text-align: center;
      margin-bottom: 40px;
    }

    .logo-icon {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 80px;
      height: 80px;
      border-radius: 50%;
      background: linear-gradient(135deg, var(--brand-green) 0%, var(--brand-red) 100%);
      font-size: 40px;
      color: #ffffff;
      margin-bottom: 20px;
      box-shadow: 0 8px 20px rgba(230, 0, 38, 0.4);
    }

    .login-title {
      font-size: 32px;
      font-weight: 800;
      margin-bottom: 12px;
      background: linear-gradient(135deg, var(--brand-green) 0%, var(--brand-red) 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }

    .login-subtitle {
      font-size: 14px;
      color: var(--text-secondary);
      font-weight: 500;
    }

    .form-group {
      margin-bottom: 24px;
    }

    .form-label {
      display: block;
      margin-bottom: 10px;
      font-weight: 600;
      color: var(--text-primary);
      font-size: 14px;
    }

    .form-label i {
      margin-right: 8px;
      color: var(--brand-green);
    }

    .form-input {
      width: 100%;
      padding: 16px 20px;
      background: var(--bg-med);
      border: 2px solid var(--border-color);
      border-radius: 12px;
      color: var(--text-primary);
      font-size: 15px;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      font-family: 'Inter', sans-serif;
    }

    .form-input:focus {
      outline: none;
      border-color: var(--brand-green);
      background: var(--bg-light);
      box-shadow: 0 0 0 4px rgba(18, 223, 56, 0.1);
    }

    .form-input::placeholder {
      color: var(--text-secondary);
    }

    .btn-login {
      width: 100%;
      padding: 18px;
      background: linear-gradient(135deg, var(--brand-green) 0%, var(--brand-red) 100%);
      color: #ffffff;
      border: none;
      border-radius: 12px;
      font-size: 16px;
      font-weight: 700;
      cursor: pointer;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      box-shadow: 0 4px 12px rgba(18, 223, 56, 0.4);
      font-family: 'Inter', sans-serif;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .btn-login:hover {
      transform: translateY(-3px);
      box-shadow: 0 8px 24px rgba(18, 223, 56, 0.5);
    }

    .btn-login:active {
      transform: translateY(-1px);
    }

    .back-to-game {
      text-align: center;
      margin-top: 32px;
      color: var(--text-secondary);
    }

    .back-to-game a {
      color: var(--brand-green);
      text-decoration: none;
      font-weight: 600;
      transition: all 0.2s;
      display: inline-flex;
      align-items: center;
      gap: 8px;
    }

    .back-to-game a:hover {
      color: var(--brand-red);
      text-decoration: underline;
    }

    .alert {
      padding: 16px 20px;
      border-radius: 12px;
      margin-bottom: 24px;
      font-size: 14px;
      font-weight: 500;
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .alert-error {
      background: linear-gradient(135deg, rgba(230, 0, 38, 0.15) 0%, rgba(230, 0, 38, 0.05) 100%);
      color: var(--brand-red);
      border: 1px solid rgba(230, 0, 38, 0.3);
    }

    .alert-error i {
      font-size: 20px;
    }

    @media (max-width: 576px) {
      .login-card {
        padding: 36px 24px;
      }

      .login-title {
        font-size: 28px;
      }

      .logo-icon {
        width: 70px;
        height: 70px;
        font-size: 35px;
      }
    }
  </style>
</head>
<body>
  <div class="login-wrapper">
    <div class="login-card">
      <div class="logo-container">
        <div class="logo-icon">
          <i class="fas fa-shield-alt"></i>
        </div>
        <h1 class="login-title">Admin Login</h1>
        <p class="login-subtitle">Secure access to admin dashboard</p>
      </div>
      
      @if(session('error'))
        <div class="alert alert-error">
          <i class="fas fa-exclamation-circle"></i>
          {{ session('error') }}
        </div>
      @endif

      <form method="POST" action="{{ route('admin.login.post') }}">
        @csrf
        
        <div class="form-group">
          <label for="email" class="form-label">
            <i class="fas fa-envelope"></i>
            Email Address
          </label>
          <input 
            type="email" 
            id="email" 
            name="email" 
            class="form-input" 
            placeholder="admin@example.com"
            value="{{ old('email') }}"
            required
            autofocus
          >
        </div>

        <div class="form-group">
          <label for="password" class="form-label">
            <i class="fas fa-lock"></i>
            Password
          </label>
          <input 
            type="password" 
            id="password" 
            name="password" 
            class="form-input" 
            placeholder="••••••••••"
            required
          >
        </div>

        <button type="submit" class="btn-login">
          <i class="fas fa-sign-in-alt"></i>
          Sign In as Admin
        </button>
      </form>

      <div class="back-to-game">
        <a href="{{ route('game') }}">
          <i class="fas fa-arrow-left"></i>
          Back to Game
        </a>
      </div>
    </div>
  </div>
</body>
</html>
