/**
 * User Menu Module
 * Handles dropdown menu functionality
 */

export function initUserMenu() {
  const menuIcon = document.getElementById('userMenuIcon');
  const dropdown = document.getElementById('userMenuDropdown');
  
  if (!menuIcon || !dropdown) return;
  
  menuIcon.addEventListener('click', function(e) {
    e.stopPropagation();
    dropdown.classList.toggle('active');
    menuIcon.setAttribute('aria-expanded', dropdown.classList.contains('active'));
  });

  dropdown.addEventListener('click', function(e) {
    e.stopPropagation();
  });

  document.addEventListener('click', function(e) {
    if (!menuIcon.contains(e.target) && !dropdown.contains(e.target)) {
      dropdown.classList.remove('active');
      menuIcon.setAttribute('aria-expanded', 'false');
    }
  });
}
