/**
 * Main Game Module
 * Initializes all game functionality
 */

import { initUserMenu } from './user-menu.js';
import { initModals } from './modal.js';
import { initSettings } from './settings.js';
import { initChat } from './chat.js';

document.addEventListener('DOMContentLoaded', function() {
  // Initialize all modules
  initUserMenu();
  initModals();
  initSettings();
  initChat();
  
  console.log('Game modules initialized');
});
