<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('flew_away_multipliers', function (Blueprint $table) {
            $table->id();
            $table->string('round_id')->unique(); // Unique identifier matching game_rounds
            $table->decimal('multiplier', 10, 2); // The multiplier when plane flew away
            $table->timestamp('flew_away_at'); // Timestamp when plane flew away
            $table->timestamps();
            
            $table->index('round_id');
            $table->index('multiplier');
            $table->index('flew_away_at');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('flew_away_multipliers');
    }
};
