<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('game_rounds', function (Blueprint $table) {
            $table->id();
            $table->string('round_id')->unique(); // Unique identifier for each round
            $table->unsignedBigInteger('user_id')->nullable(); // Nullable for rounds where user didn't bet
            $table->decimal('multiplier', 10, 2); // Final multiplier when plane flew away
            $table->decimal('bet_amount', 10, 2)->default(0); // User's bet amount (if they bet)
            $table->decimal('win_amount', 10, 2)->default(0); // User's win amount (if cashed out)
            $table->enum('result', ['win', 'loss', 'no_bet'])->default('no_bet'); // User's result
            $table->timestamp('started_at'); // When the round started
            $table->timestamp('ended_at'); // When the plane flew away
            $table->timestamps();
            
            $table->index('user_id');
            $table->index('round_id');
            $table->index('created_at');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('game_rounds');
    }
};
