<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Adds fields from lopixbet.sql users table structure.
     */
    public function up(): void
    {
        // Check columns outside the closure
        $hasOauthId = Schema::hasColumn('users', 'oauth_id');
        $hasOauthType = Schema::hasColumn('users', 'oauth_type');
        $hasAvatar = Schema::hasColumn('users', 'avatar');
        $hasLastName = Schema::hasColumn('users', 'last_name');
        $hasCpf = Schema::hasColumn('users', 'cpf');
        $hasPhone = Schema::hasColumn('users', 'phone');
        $hasLoggedIn = Schema::hasColumn('users', 'logged_in');
        $hasBanned = Schema::hasColumn('users', 'banned');
        $hasInviter = Schema::hasColumn('users', 'inviter');
        $hasInviterCode = Schema::hasColumn('users', 'inviter_code');
        $hasAffiliateRevenueShare = Schema::hasColumn('users', 'affiliate_revenue_share');
        $hasAffiliateRevenueShareFake = Schema::hasColumn('users', 'affiliate_revenue_share_fake');
        $hasAffiliateCpa = Schema::hasColumn('users', 'affiliate_cpa');
        $hasAffiliatePercentageCpa = Schema::hasColumn('users', 'affiliate_percentage_cpa');
        $hasAffiliatePercentageBaseline = Schema::hasColumn('users', 'affiliate_percentage_baseline');
        $hasAffiliateBaseline = Schema::hasColumn('users', 'affiliate_baseline');
        $hasIsDemoAgent = Schema::hasColumn('users', 'is_demo_agent');
        $hasStatus = Schema::hasColumn('users', 'status');
        $hasLanguage = Schema::hasColumn('users', 'language');
        $hasRoleId = Schema::hasColumn('users', 'role_id');
        $hasAffiliateBauBaseline = Schema::hasColumn('users', 'affiliate_bau_baseline');
        $hasAffiliateBauValue = Schema::hasColumn('users', 'affiliate_bau_value');
        $hasAffiliateBauAposta = Schema::hasColumn('users', 'affiliate_bau_aposta');
        $hasLastActivity = Schema::hasColumn('users', 'last_activity');

        Schema::table('users', function (Blueprint $table) use (
            $hasOauthId, $hasOauthType, $hasAvatar, $hasLastName, $hasCpf, $hasPhone,
            $hasLoggedIn, $hasBanned, $hasInviter, $hasInviterCode,
            $hasAffiliateRevenueShare, $hasAffiliateRevenueShareFake, $hasAffiliateCpa,
            $hasAffiliatePercentageCpa, $hasAffiliatePercentageBaseline, $hasAffiliateBaseline,
            $hasIsDemoAgent, $hasStatus, $hasLanguage, $hasRoleId,
            $hasAffiliateBauBaseline, $hasAffiliateBauValue, $hasAffiliateBauAposta,
            $hasLastActivity
        ) {
            if (!$hasOauthId) {
                $table->string('oauth_id')->nullable()->after('remember_token');
            }
            if (!$hasOauthType) {
                $table->string('oauth_type')->nullable()->after('oauth_id');
            }
            if (!$hasAvatar) {
                $table->string('avatar')->nullable()->after('oauth_type');
            }
            if (!$hasLastName) {
                $table->string('last_name')->nullable()->after('name');
            }
            if (!$hasCpf) {
                $table->string('cpf', 20)->nullable()->after('last_name');
            }
            if (!$hasPhone) {
                $table->string('phone', 30)->nullable()->after('cpf');
            }
            if (!$hasLoggedIn) {
                $table->tinyInteger('logged_in')->default(0)->after('phone');
            }
            if (!$hasBanned) {
                $table->tinyInteger('banned')->default(0)->after('logged_in');
            }
            if (!$hasInviter) {
                $table->integer('inviter')->nullable()->after('banned');
            }
            if (!$hasInviterCode) {
                $table->string('inviter_code', 25)->nullable()->after('inviter');
            }
            if (!$hasAffiliateRevenueShare) {
                $table->decimal('affiliate_revenue_share', 5, 2)->default(10.00)->after('inviter_code');
            }
            if (!$hasAffiliateRevenueShareFake) {
                $table->bigInteger('affiliate_revenue_share_fake')->nullable()->after('affiliate_revenue_share');
            }
            if (!$hasAffiliateCpa) {
                $table->decimal('affiliate_cpa', 20, 2)->default(10.00)->after('affiliate_revenue_share_fake');
            }
            if (!$hasAffiliatePercentageCpa) {
                $table->decimal('affiliate_percentage_cpa', 10, 2)->nullable()->after('affiliate_cpa');
            }
            if (!$hasAffiliatePercentageBaseline) {
                $table->string('affiliate_percentage_baseline')->nullable()->after('affiliate_percentage_cpa');
            }
            if (!$hasAffiliateBaseline) {
                $table->decimal('affiliate_baseline', 20, 2)->default(40.00)->after('affiliate_percentage_baseline');
            }
            if (!$hasIsDemoAgent) {
                $table->tinyInteger('is_demo_agent')->default(0)->after('affiliate_baseline');
            }
            if (!$hasStatus) {
                $table->string('status', 50)->default('active')->after('is_demo_agent');
            }
            if (!$hasLanguage) {
                $table->string('language')->default('pt_BR')->after('status');
            }
            if (!$hasRoleId) {
                $table->integer('role_id')->default(3)->after('language');
            }
            if (!$hasAffiliateBauBaseline) {
                $table->decimal('affiliate_bau_baseline', 10, 2)->nullable()->after('role_id');
            }
            if (!$hasAffiliateBauValue) {
                $table->decimal('affiliate_bau_value', 10, 2)->nullable()->after('affiliate_bau_baseline');
            }
            if (!$hasAffiliateBauAposta) {
                $table->decimal('affiliate_bau_aposta', 10, 2)->nullable()->after('affiliate_bau_value');
            }
            if (!$hasLastActivity) {
                $table->string('last_activity')->nullable()->after('affiliate_bau_aposta');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $columnsToDrop = [
                'oauth_id', 'oauth_type', 'avatar', 'last_name', 'cpf', 'phone',
                'logged_in', 'banned', 'inviter', 'inviter_code',
                'affiliate_revenue_share', 'affiliate_revenue_share_fake', 'affiliate_cpa',
                'affiliate_percentage_cpa', 'affiliate_percentage_baseline', 'affiliate_baseline',
                'is_demo_agent', 'status', 'language', 'role_id',
                'affiliate_bau_baseline', 'affiliate_bau_value', 'affiliate_bau_aposta',
                'last_activity'
            ];

            foreach ($columnsToDrop as $column) {
                if (Schema::hasColumn('users', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
