<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    protected $table = 'deposits';
    
    protected $fillable = [
        'payment_id',
        'user_id',
        'amount',
        'type',
        'proof',
        'status',
        'currency',
        'symbol',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'status' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
