<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class RegisterController extends Controller
{
    public function showRegisterForm()
    {
        return view('auth.register');
    }

    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        // Build user data with only fields that exist
        $userData = [
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ];

        // Add optional fields if columns exist in the database
        try {
            // Check if columns exist by attempting to query the schema
            $columns = Schema::getColumnListing('users');
            
            if (in_array('inviter_code', $columns)) {
                $userData['inviter_code'] = Str::random(8);
            }
            if (in_array('status', $columns)) {
                $userData['status'] = 'active';
            }
            if (in_array('language', $columns)) {
                $userData['language'] = 'pt_BR';
            }
            if (in_array('role_id', $columns)) {
                $userData['role_id'] = 3;
            }
            if (in_array('last_activity', $columns)) {
                $userData['last_activity'] = now();
            }
        } catch (\Exception $e) {
            // If schema check fails, just use basic fields
            \Log::warning('Could not check users table schema: ' . $e->getMessage());
        }

        $user = User::create($userData);

        Auth::login($user);

        return redirect('/');
    }
}
