<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = [
            'site_name' => Cache::get('settings.site_name', 'Aviator Game'),
            'min_deposit' => Cache::get('settings.min_deposit', 10),
            'max_deposit' => Cache::get('settings.max_deposit', 10000),
            'min_withdrawal' => Cache::get('settings.min_withdrawal', 20),
            'max_withdrawal' => Cache::get('settings.max_withdrawal', 50000),
            'withdrawal_fee' => Cache::get('settings.withdrawal_fee', 0),
            'default_currency' => Cache::get('settings.default_currency', 'BRL'),
            'maintenance_mode' => Cache::get('settings.maintenance_mode', false),
            'registration_enabled' => Cache::get('settings.registration_enabled', true),
        ];

        return view('admin.settings', compact('settings'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'site_name' => 'required|string|max:255',
            'min_deposit' => 'required|numeric|min:1',
            'max_deposit' => 'required|numeric|min:1',
            'min_withdrawal' => 'required|numeric|min:1',
            'max_withdrawal' => 'required|numeric|min:1',
            'withdrawal_fee' => 'required|numeric|min:0|max:100',
            'default_currency' => 'required|string|max:10',
            'maintenance_mode' => 'required|boolean',
            'registration_enabled' => 'required|boolean',
        ]);

        // Cache all settings
        Cache::forever('settings.site_name', $validated['site_name']);
        Cache::forever('settings.min_deposit', $validated['min_deposit']);
        Cache::forever('settings.max_deposit', $validated['max_deposit']);
        Cache::forever('settings.min_withdrawal', $validated['min_withdrawal']);
        Cache::forever('settings.max_withdrawal', $validated['max_withdrawal']);
        Cache::forever('settings.withdrawal_fee', $validated['withdrawal_fee']);
        Cache::forever('settings.default_currency', $validated['default_currency']);
        Cache::forever('settings.maintenance_mode', $validated['maintenance_mode']);
        Cache::forever('settings.registration_enabled', $validated['registration_enabled']);

        return redirect()->back()
            ->with('success', 'Settings updated successfully');
    }
}
